/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.web.servlets;

import java.io.IOException;
import java.util.HashMap;
import java.util.Locale;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.util.JRLoader;
import net.sf.jasperreports.engine.util.MessageUtil;
import net.sf.jasperreports.web.servlets.AbstractServlet;
import net.sf.jasperreports.web.util.VelocityUtil;
import net.sf.jasperreports.web.util.WebUtil;

public class ResourceServlet
extends AbstractServlet {
    private static final long serialVersionUID = 10200L;

    public void service(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        WebUtil webUtil = WebUtil.getInstance(this.getJasperReportsContext());
        String resource = webUtil.getResourceUri(request);
        boolean isDynamicResource = webUtil.isDynamicResource(request);
        String resourceBundleName = webUtil.getResourceBundleForResource(request);
        Locale locale = webUtil.getResourceLocale(request);
        try {
            byte[] bytes = null;
            if (resource != null && resource.indexOf(".vm.") != -1 && (isDynamicResource || resourceBundleName != null || locale != null)) {
                HashMap<String, Object> contextMap = new HashMap<String, Object>();
                contextMap.put("path", request.getContextPath() + webUtil.getResourcesBasePath());
                locale = locale == null ? Locale.getDefault() : locale;
                contextMap.put("msgProvider", MessageUtil.getInstance(this.getJasperReportsContext()).getLocalizedMessageProvider(resourceBundleName, locale));
                String resourceString = VelocityUtil.processTemplate(resource, contextMap);
                if (resourceString != null) {
                    bytes = resourceString.getBytes("UTF-8");
                }
            } else {
                bytes = JRLoader.loadBytesFromResource(resource);
            }
            if (resource.endsWith(".js")) {
                response.setContentType("text/javascript");
            } else if (resource.endsWith(".css")) {
                response.setContentType("text/css");
            }
            response.setHeader("Expires", "Sat, 6 May 1995 12:00:00 GMT");
            response.setHeader("Cache-Control", "no-store, no-cache, must-revalidate");
            response.addHeader("Cache-Control", "post-check=0, pre-check=0");
            response.setHeader("Pragma", "no-cache");
            response.getOutputStream().write(bytes);
        }
        catch (JRException e) {
            e.printStackTrace();
        }
    }
}

