/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.util;

import net.sf.jasperreports.engine.JRCommonText;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRPrintText;
import net.sf.jasperreports.engine.JRPropertiesHolder;
import net.sf.jasperreports.engine.JRPropertiesUtil;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JRStyledTextAttributeSelector;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.fill.JRMeasuredText;
import net.sf.jasperreports.engine.fill.JRTextMeasurer;
import net.sf.jasperreports.engine.util.JRSingletonCache;
import net.sf.jasperreports.engine.util.JRStyledText;
import net.sf.jasperreports.engine.util.JRStyledTextParser;
import net.sf.jasperreports.engine.util.JRTextMeasurerFactory;

public final class JRTextMeasurerUtil {
    private JasperReportsContext jasperReportsContext;
    public static final String PROPERTY_TEXT_MEASURER_FACTORY = "net.sf.jasperreports.text.measurer.factory";
    private static final JRSingletonCache<net.sf.jasperreports.engine.fill.JRTextMeasurerFactory> cache = new JRSingletonCache<net.sf.jasperreports.engine.fill.JRTextMeasurerFactory>(net.sf.jasperreports.engine.fill.JRTextMeasurerFactory.class);

    private JRTextMeasurerUtil(JasperReportsContext jasperReportsContext) {
        this.jasperReportsContext = jasperReportsContext;
    }

    public static JRTextMeasurerUtil getInstance(JasperReportsContext jasperReportsContext) {
        return new JRTextMeasurerUtil(jasperReportsContext);
    }

    public JRTextMeasurer createTextMeasurer(JRCommonText text) {
        JRPropertiesHolder propertiesHolder = text instanceof JRPropertiesHolder ? (JRPropertiesHolder)((Object)text) : null;
        return this.createTextMeasurer(text, propertiesHolder);
    }

    public JRTextMeasurer createTextMeasurer(JRCommonText text, JRPropertiesHolder propertiesHolder) {
        JRTextMeasurerFactory factory = this.getFactory(propertiesHolder);
        return factory.createMeasurer(this.jasperReportsContext, text);
    }

    public net.sf.jasperreports.engine.fill.JRTextMeasurerFactory getTextMeasurerFactory(JRPropertiesHolder propertiesHolder) {
        return this.getFactory(propertiesHolder);
    }

    public JRTextMeasurerFactory getFactory(JRPropertiesHolder propertiesHolder) {
        String factoryClass = this.getTextMeasurerFactoryClass(propertiesHolder);
        try {
            net.sf.jasperreports.engine.fill.JRTextMeasurerFactory factory = cache.getCachedInstance(factoryClass);
            if (factory instanceof JRTextMeasurerFactory) {
                return (JRTextMeasurerFactory)factory;
            }
            return new WrappingTextMeasurerFactory(factory);
        }
        catch (JRException e) {
            throw new JRRuntimeException(e);
        }
    }

    protected String getTextMeasurerFactoryClass(JRPropertiesHolder propertiesHolder) {
        String factory = JRPropertiesUtil.getInstance(this.jasperReportsContext).getProperty(propertiesHolder, PROPERTY_TEXT_MEASURER_FACTORY);
        String factoryClassProperty = "net.sf.jasperreports.text.measurer.factory." + factory;
        String factoryClass = JRPropertiesUtil.getInstance(this.jasperReportsContext).getProperty(propertiesHolder, factoryClassProperty);
        if (factoryClass == null) {
            factoryClass = factory;
        }
        return factoryClass;
    }

    public void measureTextElement(JRPrintText printText) {
        JRStyledText styledText;
        JRMeasuredText measuredText;
        String text = printText.getText();
        JRTextMeasurer textMeasurer = this.createTextMeasurer(printText);
        if (text == null) {
            text = "";
        }
        printText.setTextHeight((measuredText = textMeasurer.measure(styledText = JRStyledTextParser.getInstance().getStyledText(JRStyledTextAttributeSelector.NO_BACKCOLOR.getStyledTextAttributes(printText), text, "styled".equals(printText.getMarkup()), JRStyledTextAttributeSelector.getTextLocale(printText)), 0, 0, false)).getTextHeight() < (float)printText.getHeight() ? measuredText.getTextHeight() : (float)printText.getHeight());
        printText.setLeadingOffset(measuredText.getLeadingOffset());
        printText.setLineSpacingFactor(measuredText.getLineSpacingFactor());
        int textEnd = measuredText.getTextOffset();
        String printedText = "styled".equals(printText.getMarkup()) ? JRStyledTextParser.getInstance().write(styledText, 0, textEnd) : text.substring(0, textEnd);
        printText.setText(printedText);
    }

    public static class WrappingTextMeasurerFactory
    implements JRTextMeasurerFactory {
        private net.sf.jasperreports.engine.fill.JRTextMeasurerFactory factory;

        public WrappingTextMeasurerFactory(net.sf.jasperreports.engine.fill.JRTextMeasurerFactory factory) {
            this.factory = factory;
        }

        @Override
        public JRTextMeasurer createMeasurer(JRCommonText text) {
            return this.factory.createMeasurer(text);
        }

        @Override
        public JRTextMeasurer createMeasurer(JasperReportsContext jasperReportsContext, JRCommonText text) {
            return this.factory.createMeasurer(text);
        }
    }
}

