/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.data.jdbc;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.SQLException;
import java.util.Map;
import java.util.Properties;
import net.sf.jasperreports.data.AbstractClasspathAwareDataAdapterService;
import net.sf.jasperreports.data.jdbc.JdbcDataAdapter;
import net.sf.jasperreports.engine.DefaultJasperReportsContext;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.util.CompositeClassloader;
import net.sf.jasperreports.engine.util.JRClassLoader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JdbcDataAdapterService
extends AbstractClasspathAwareDataAdapterService {
    private static final Log log = LogFactory.getLog(JdbcDataAdapterService.class);
    private Connection connection = null;

    public JdbcDataAdapterService(JasperReportsContext jasperReportsContext, JdbcDataAdapter jdbcDataAdapter) {
        super(jasperReportsContext, jdbcDataAdapter);
    }

    public JdbcDataAdapterService(JdbcDataAdapter jdbcDataAdapter) {
        this((JasperReportsContext)DefaultJasperReportsContext.getInstance(), jdbcDataAdapter);
    }

    public JdbcDataAdapter getJdbcDataAdapter() {
        return (JdbcDataAdapter)this.getDataAdapter();
    }

    @Override
    public void contributeParameters(Map<String, Object> parameters) throws JRException {
        JdbcDataAdapter jdbcDataAdapter = this.getJdbcDataAdapter();
        if (jdbcDataAdapter != null) {
            ClassLoader oldThreadClassLoader = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(new CompositeClassloader(this.getClassLoader(), oldThreadClassLoader));
                Class<?> clazz = JRClassLoader.loadClassForRealName(jdbcDataAdapter.getDriver());
                Driver driver = (Driver)clazz.newInstance();
                Properties connectProps = new Properties();
                Map<String, String> map = jdbcDataAdapter.getProperties();
                if (map != null) {
                    for (String key : map.keySet()) {
                        connectProps.setProperty(key, map.get(key));
                    }
                }
                String password = jdbcDataAdapter.getPassword();
                if (!jdbcDataAdapter.isSavePassword()) {
                    password = this.getPassword();
                }
                connectProps.setProperty("user", jdbcDataAdapter.getUsername());
                connectProps.setProperty("password", password);
                this.connection = driver.connect(jdbcDataAdapter.getUrl(), connectProps);
                if (this.connection == null) {
                    throw new SQLException("No suitable driver found for " + jdbcDataAdapter.getUrl());
                }
            }
            catch (Exception ex) {
                throw new JRException(ex);
            }
            finally {
                Thread.currentThread().setContextClassLoader(oldThreadClassLoader);
            }
            parameters.put("REPORT_CONNECTION", this.connection);
        }
    }

    public String getPassword() throws JRException {
        throw new JRException("This service implementation needs the password to be saved in the data adapter.");
    }

    @Override
    public void dispose() {
        block3: {
            if (this.connection != null) {
                try {
                    this.connection.close();
                }
                catch (Exception ex) {
                    if (!log.isErrorEnabled()) break block3;
                    log.error((Object)"Error while closing the connection.", (Throwable)ex);
                }
            }
        }
    }
}

